<?php
include "../../conn.php";
date_default_timezone_set("Asia/Kolkata");

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');

$userId = 3688014;
$userName = "MemberNNGN74JA";

// Get status
$statusRes = $conn->query("SELECT * FROM invited_wheel_status WHERE userId = $userId LIMIT 1");
$status = $statusRes->fetch_assoc();
$freeSpinCount = (int)$status['freeSpinCount'];
$isFirstSpinDone = (bool)$status['isFirstSpinDone'];

// If no free spin available
if ($freeSpinCount <= 0) {
    echo json_encode([
        "code" => 1,
        "msg" => "No free spin available",
        "msgCode" => 1,
        "serviceNowTime" => date("Y-m-d H:i:s")
    ]);
    exit;
}

// User balance
$balRes = $conn->query("SELECT motta FROM shonu_kaichila WHERE balakedara = $userId LIMIT 1");
$balance = 0;
if ($balRes && $balRes->num_rows > 0) {
    $row = $balRes->fetch_assoc();
    $balance = (float)$row['motta'];
}

// Disk prizes
$diskDisplayAmount = [500.0, 5.0, 10.0, 20.0, 30.0, 50.0, 80.0];
$noWinningRandomAmount = [0.0, 10.0];

// Random prize
$allPrizes = array_merge($diskDisplayAmount, $noWinningRandomAmount);
$prizeAmount = $allPrizes[array_rand($allPrizes)];

// Update balance
$newBalance = $balance + $prizeAmount;
$conn->query("UPDATE shonu_kaichila SET motta = $newBalance WHERE balakedara = $userId");

// Insert spin record
$conn->query("INSERT INTO invited_wheel_records (userId, userName, invitedWheelAmount, prizeAmount) 
VALUES ($userId, '$userName', $balance, $prizeAmount)");

// Update wheel status
$conn->query("UPDATE invited_wheel_status SET freeSpinCount = freeSpinCount - 1, isFirstSpinDone = 1 WHERE userId = $userId");

$data = [
    "userId" => $userId,
    "userName" => $userName,
    "invitedWheelAmount" => $balance,
    "prizeAmount" => $prizeAmount,
    "createTime" => date("Y-m-d H:i:s")
];

echo json_encode([
    "data" => $data,
    "code" => 0,
    "msg" => "Succeed",
    "msgCode" => 0,
    "serviceNowTime" => date("Y-m-d H:i:s")
], JSON_PRETTY_PRINT);
