<?php
// Made By IndiaHost.Co
include "../../conn.php";
include "../../functions2.php";

// Load proxy configuration
$proxyConfig = require(__DIR__ . '/../proxy_config.php');

header('Content-Type: application/json; charset=utf-8');
header('Strict-Transport-Security: max-age=31536000');
header('Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept, Authorization');
header('Access-Control-Allow-Credentials: true');
$origin = isset($_SERVER['HTTP_ORIGIN']) ? $_SERVER['HTTP_ORIGIN'] : '';
header('Access-Control-Allow-Origin: ' . $origin);
header('Vary: Origin');

date_default_timezone_set("Asia/Kolkata");
$shnunc = date("Y-m-d H:i:s");

$res = [
    'code' => 11,
    'msg' => 'Method not allowed',
    'msgCode' => 12,
    'serviceNowTime' => $shnunc,
];

function generateUrl($fileName)
{
    $protocol = "https://";
    $host = $_SERVER['HTTP_HOST'];
    $uri = $_SERVER['REQUEST_URI'];

    $pathParts = explode("/", trim($uri, "/"));
    if (!empty($pathParts) && count($pathParts) > 1) {
        array_pop($pathParts);
    }

    return $protocol . $host . "/" . implode("/", $pathParts) . "/" . $fileName;
}

/**
 * Call Proxy API to get game launch URL
 * Routes game requests through the proxy server
 */
function getGameUrlFromProxy($username, $gameUid, $creditAmount, $currencyCode, $language, $platform, $proxyConfig, $homeUrl = '', $callbackUrl = '')
{
    $proxyApiUrl = rtrim($proxyConfig['proxy_api_url'], '/') . '/api/game/launch';

    // Ensure credit_amount is always a valid numeric value
    if (!isset($creditAmount) || $creditAmount === null || $creditAmount === '') {
        $creditAmount = 0;
    }
    $creditAmount = (float) $creditAmount;
    if ($creditAmount < 0) {
        $creditAmount = 0;
    }

    // Prepare request payload - ensure all required fields are present
    $payload = [
        'username' => (string) $username,
        'game_uid' => (string) $gameUid,
        'credit_amount' => (string) number_format($creditAmount, 2, '.', ''), // Format to 2 decimal places
        'currency_code' => (string) $currencyCode,
        'language' => (string) $language,
        'platform' => (int) $platform
    ];

    // Add optional parameters
    if (!empty($homeUrl)) {
        $payload['home_url'] = $homeUrl;
    }

    if (!empty($callbackUrl)) {
        $payload['callback_url'] = $callbackUrl;
    }

    // Prepare headers
    $headers = [
        'Content-Type: application/json',
        'X-API-KEY: ' . $proxyConfig['client_api_key']
    ];

    // Add Origin header for domain validation
    // This is required for the proxy server to validate the allowed_domain
    if (!empty($proxyConfig['client_domain'])) {
        $clientDomain = $proxyConfig['client_domain'];
        // Remove protocol if present
        $clientDomain = preg_replace('#^https?://#', '', $clientDomain);
        // Remove trailing slash
        $clientDomain = rtrim($clientDomain, '/');
        // Remove port if present
        $clientDomain = explode(':', $clientDomain)[0];
        $headers[] = 'Origin: https://' . $clientDomain;
    } else {
        // Fallback: try to extract from homeUrl
        if (!empty($homeUrl)) {
            $parsed = parse_url($homeUrl);
            if (!empty($parsed['host'])) {
                $headers[] = 'Origin: https://' . $parsed['host'];
            }
        }
    }

    // Log the URL and payload being sent for debugging
    error_log("Proxy API Call: {$proxyApiUrl}");
    error_log("Proxy API Payload: " . json_encode($payload));

    // Get SSL verification setting from config (default: true for security)
    $sslVerify = isset($proxyConfig['ssl_verify']) ? (bool) $proxyConfig['ssl_verify'] : true;

    // Initialize cURL
    $ch = curl_init($proxyApiUrl);
    curl_setopt_array($ch, [
        CURLOPT_POST => true,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER => $headers,
        CURLOPT_POSTFIELDS => json_encode($payload),
        CURLOPT_SSL_VERIFYPEER => $sslVerify,
        CURLOPT_SSL_VERIFYHOST => $sslVerify ? 2 : 0,
        CURLOPT_FOLLOWLOCATION => true,  // Follow redirects (301, 302, etc.)
        CURLOPT_MAXREDIRS => 5,          // Maximum number of redirects to follow
        CURLOPT_TIMEOUT => 30,
        CURLOPT_CONNECTTIMEOUT => 10,
        CURLOPT_VERBOSE => false
    ]);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $finalUrl = curl_getinfo($ch, CURLINFO_EFFECTIVE_URL); // Get final URL after redirects
    $curlError = curl_error($ch);
    $curlErrno = curl_errno($ch);
    $curlInfo = curl_getinfo($ch);
    curl_close($ch);

    // Handle errors with detailed diagnostics
    if ($curlError) {
        $errorDetails = [
            'error' => $curlError,
            'errno' => $curlErrno,
            'url' => $proxyApiUrl,
            'http_code' => $httpCode,
            'connect_time' => $curlInfo['connect_time'] ?? 'N/A',
            'total_time' => $curlInfo['total_time'] ?? 'N/A',
            'primary_ip' => $curlInfo['primary_ip'] ?? 'N/A',
            'primary_port' => $curlInfo['primary_port'] ?? 'N/A',
            'local_ip' => $curlInfo['local_ip'] ?? 'N/A',
            'local_port' => $curlInfo['local_port'] ?? 'N/A'
        ];

        error_log("Proxy API Error: Failed to connect to {$proxyApiUrl} | Error: {$curlError} (Code: {$curlErrno}) | Details: " . json_encode($errorDetails));

        // If connection refused (error 7) and using HTTPS, try HTTP as fallback
        if ($curlErrno == CURLE_COULDNT_CONNECT && strpos($proxyApiUrl, 'https://') === 0) {
            $httpFallbackUrl = str_replace('https://', 'http://', $proxyApiUrl);
            error_log("Proxy API: HTTPS connection refused, attempting HTTP fallback: {$httpFallbackUrl}");

            $ch2 = curl_init($httpFallbackUrl);
            curl_setopt_array($ch2, [
                CURLOPT_POST => true,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_HTTPHEADER => $headers,
                CURLOPT_POSTFIELDS => json_encode($payload),
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_MAXREDIRS => 5,
                CURLOPT_TIMEOUT => 30,
                CURLOPT_CONNECTTIMEOUT => 10
            ]);

            $response2 = curl_exec($ch2);
            $httpCode2 = curl_getinfo($ch2, CURLINFO_HTTP_CODE);
            $curlError2 = curl_error($ch2);
            curl_close($ch2);

            if (!$curlError2 && $httpCode2 == 200) {
                error_log("Proxy API: HTTP fallback successful - Server is using HTTP instead of HTTPS");
                $response = $response2;
                $httpCode = $httpCode2;
            } else {
                error_log("Proxy API: HTTP fallback also failed - {$curlError2} | HTTP: {$httpCode2}");
                return null;
            }
        }
        // If SSL error, try with SSL verification disabled as fallback (for testing only)
        elseif ($curlErrno == CURLE_SSL_CONNECT_ERROR || $curlErrno == CURLE_SSL_CERTPROBLEM || strpos($curlError, 'SSL') !== false) {
            error_log("Proxy API: SSL error detected, attempting fallback with SSL verification disabled...");

            $ch2 = curl_init($proxyApiUrl);
            curl_setopt_array($ch2, [
                CURLOPT_POST => true,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_HTTPHEADER => $headers,
                CURLOPT_POSTFIELDS => json_encode($payload),
                CURLOPT_SSL_VERIFYPEER => false,  // Disable SSL verification for testing
                CURLOPT_SSL_VERIFYHOST => false,  // Disable host verification for testing
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_MAXREDIRS => 5,
                CURLOPT_TIMEOUT => 30,
                CURLOPT_CONNECTTIMEOUT => 10
            ]);

            $response2 = curl_exec($ch2);
            $httpCode2 = curl_getinfo($ch2, CURLINFO_HTTP_CODE);
            $curlError2 = curl_error($ch2);
            curl_close($ch2);

            if (!$curlError2 && $httpCode2 == 200) {
                error_log("Proxy API: Fallback connection successful (SSL verification disabled)");
                $response = $response2;
                $httpCode = $httpCode2;
            } else {
                error_log("Proxy API: Fallback also failed - {$curlError2} | HTTP: {$httpCode2}");
                return null;
            }
        } else {
            return null;
        }
    }

    if ($httpCode !== 200) {
        // Log more details about the error
        $responsePreview = is_string($response) ? substr($response, 0, 500) : json_encode($response);
        error_log("Proxy API HTTP Error: {$httpCode} | Original URL: {$proxyApiUrl} | Final URL: {$finalUrl} | Response: {$responsePreview}");
        return null;
    }

    // Log successful call (optional, can be removed in production)
    if ($finalUrl !== $proxyApiUrl) {
        error_log("Proxy API Redirect: {$proxyApiUrl} → {$finalUrl}");
    }

    // Parse response
    $responseData = json_decode($response, true);

    if (isset($responseData['status']) && $responseData['status'] === true && isset($responseData['data']['game_url'])) {
        return $responseData['data']['game_url'];
    }

    error_log("Proxy API Invalid Response: " . $response);
    return null;
}

/**
 * Check if vendor code should be routed through proxy
 * NOTE: This function is kept for backward compatibility but is no longer used.
 * ALL vendors now route through proxy by default.
 */
function shouldRouteThroughProxy($vendorCode, $proxyConfig)
{
    // Always return true - all vendors route through proxy
    return true;
}


$shonubody = file_get_contents("php://input");
$shonupost = json_decode($shonubody, true);

if ($_SERVER['REQUEST_METHOD'] != 'GET') {
    if (
        isset($shonupost['language']) &&
        isset($shonupost['random']) &&
        isset($shonupost['signature']) &&
        isset($shonupost['timestamp'])
    ) {
        $language = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['language'] ?? ''));
        $random = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['random'] ?? ''));
        $signature = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['signature'] ?? ''));
        $vendorCode = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['vendorCode'] ?? ''));
        $gameCode = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['gameCode'] ?? ''));
        $phonetype = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['phonetype'] ?? ''));

        $shonustr = '{"gameCode":"' . $gameCode . '","language":' . $language . ',"phonetype":' . $phonetype . ',"random":"' . $random . '","vendorCode":' . $vendorCode . '}';
        $shonusign = strtoupper(md5($shonustr));

        if ($shonusign != $signature) {
            $bearer = explode(" ", $_SERVER['HTTP_AUTHORIZATION'] ?? '');
            $author = $bearer[1] ?? '';

            $is_jwt_valid = is_jwt_valid($author);
            $data_auth = json_decode($is_jwt_valid, true);

            if ($data_auth['status'] === 'Success') {
                $sesquery = "SELECT token, mobile, id FROM shonu_subjects WHERE akshinak = '$author'";
                $sesresult = $conn->query($sesquery);
                $sesnum = mysqli_num_rows($sesresult);
                $row = $sesresult->fetch_assoc();

                $uid = $row['token'] ?? null;
                $no = $row['mobile'] ?? null;
                $primaryid = $row['id'] ?? null;

                //-----------------------------------//
                $sesquery2 = "SELECT motta FROM shonu_kaichila WHERE balakedara = '$primaryid'";
                $sesresult2 = $conn->query($sesquery2);
                $row2 = $sesresult2->fetch_assoc();
                $balance = $row2['motta'] ?? null;

                function getGTypeFromMType($mType)
                {
                    if ($mType >= 7000 && $mType <= 7099)
                        return 7;
                    if ($mType >= 8000 && $mType <= 8099)
                        return 0;
                    if ($mType >= 9000 && $mType <= 9099)
                        return 9;
                    if ($mType >= 12000 && $mType <= 12099)
                        return 12;
                    if ($mType >= 14000 && $mType <= 14099)
                        return 0;
                    if ($mType >= 15000 && $mType <= 15099)
                        return 0;
                    if ($mType >= 18000 && $mType <= 18099)
                        return 18;
                    return 0; // default fallback
                }

                // ALL vendors route through proxy server - no exceptions
                // Use token (uid) as username for proxy - this is what game-file uses to identify users
                $username = $uid ?? $no ?? 'user_' . $primaryid;
                $gameUid = $gameCode;

                // Ensure credit_amount is always a valid numeric value
                // Handle null, empty string, or invalid values
                $balanceValue = $balance ?? 0;
                if ($balanceValue === '' || $balanceValue === null || !is_numeric($balanceValue)) {
                    $balanceValue = 0;
                }
                $creditAmount = (float) $balanceValue;

                // Ensure credit_amount is never negative
                if ($creditAmount < 0) {
                    $creditAmount = 0;
                }

                // Log balance retrieval for debugging
                if ($creditAmount <= 0) {
                    error_log("GetGameUrl Warning: User {$username} (ID: {$primaryid}) has balance {$creditAmount}. Balance record exists: " . ($row2 ? 'yes' : 'no'));
                }
                $currencyCode = $proxyConfig['default_currency'];

                // Map language
                $langCode = $proxyConfig['language_map'][(int) $language] ?? $proxyConfig['default_language'];

                // Map platform
                $platform = $proxyConfig['platform_map'][(int) $phonetype] ?? $proxyConfig['default_platform'];

                // Generate callback URL (proxy server callback endpoint)
                $callbackUrl = rtrim($proxyConfig['proxy_api_url'], '/') . '/api/huidu/callback';

                // Generate home URL (return URL)
                $homeUrl = generateUrl('index.html');

                // Call proxy API - ALL vendors go through proxy
                $game = getGameUrlFromProxy($username, $gameUid, $creditAmount, $currencyCode, $langCode, $platform, $proxyConfig, $homeUrl, $callbackUrl);

                // If proxy fails, return error (no fallback to direct vendor URLs)
                if ($game === null) {
                    error_log("Proxy API failed for vendor: {$vendorCode}, game: {$gameCode}, user: {$username}");
                    $res['code'] = 6;
                    $res['msg'] = 'Game launch failed - proxy server error';
                    $res['msgCode'] = 5;
                    http_response_code(500);
                    echo json_encode($res);
                    exit;
                }

                if ($sesnum === 1) {
                    $data['url'] = $game;
                    $data['returnType'] = 1;
                    $res['data'] = $data;
                    $res['code'] = 0;
                    $res['msg'] = 'Succeed';
                    $res['msgCode'] = 0;
                    http_response_code(200);
                    echo json_encode($res);
                    exit;
                } else {
                    $res['code'] = 4;
                    $res['msg'] = 'No operation permission';
                    $res['msgCode'] = 2;
                    http_response_code(401);
                    echo json_encode($res);
                    exit;
                }
            } else {
                $res['code'] = 4;
                $res['msg'] = 'No operation permission';
                $res['msgCode'] = 2;
                http_response_code(401);
                echo json_encode($res);
                exit;
            }
        } else {
            $res['code'] = 5;
            $res['msg'] = 'Wrong signature';
            $res['msgCode'] = 3;
            http_response_code(200);
            echo json_encode($res);
            exit;
        }
    } else {
        $res['code'] = 7;
        $res['msg'] = 'Param is Invalid';
        $res['msgCode'] = 6;
        http_response_code(200);
        echo json_encode($res);
        exit;
    }
} else {
    http_response_code(405);
    echo json_encode($res);
    exit;
}
?>