<?php
	include "../../conn.php";

	header('Content-Type: application/json; charset=utf-8');
	header('Strict-Transport-Security: max-age=31536000');
	header('Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept, Authorization');
	header('Access-Control-Allow-Credentials: true');

	$origin = isset($_SERVER['HTTP_ORIGIN']) ? $_SERVER['HTTP_ORIGIN'] : '';
	header('Access-Control-Allow-Origin: ' . $origin);
	header('Vary: Origin');

	date_default_timezone_set("Asia/Kolkata");
	$serviceTime = date("Y-m-d H:i:s");

	$res = [
		'code' => 11,
		'msg' => 'Method not allowed',
		'msgCode' => 12,
		'serviceNowTime' => $serviceTime
	];

	$body = file_get_contents("php://input");
	$post = json_decode($body, true);

	if ($_SERVER['REQUEST_METHOD'] != 'GET') {

		if (
			isset($post['language']) &&
			isset($post['pageNo']) &&
			isset($post['pageSize']) &&
			isset($post['random']) &&
			isset($post['signature']) &&
			isset($post['timestamp'])
		) {

			$language  = mysqli_real_escape_string($conn, $post['language']);
			$pageNo    = mysqli_real_escape_string($conn, $post['pageNo']);
			$pageSize  = mysqli_real_escape_string($conn, $post['pageSize']);
			$random    = mysqli_real_escape_string($conn, $post['random']);
			$signature = mysqli_real_escape_string($conn, $post['signature']);

			$signStr = '{"language":'.$language.',"pageNo":'.$pageNo.',"pageSize":'.$pageSize.',"random":"'.$random.'"}';
			$makeSign = strtoupper(md5($signStr));

			if ($makeSign === $signature) {

				$list = [];

				$list[0]['title'] = 'Welcome to Royelclub';
				$list[0]['siteMessage'] =
					'Royelclub is a secure and trusted online platform designed to provide a smooth and transparent experience for all users. We offer fast deposits, quick withdrawals, strong data security, and 24/7 customer support to keep your funds and information fully protected. Thousands of users rely on Royelclub for stability, safety, and quality service.';
				$list[0]['addtime'] = '2025-07-01 12:01:22';

				$list[1]['title'] = 'Royelclub Payment & Support Notice';
				$list[1]['siteMessage'] =
					'Please ensure that all payment details are entered correctly to avoid delays. If you encounter any issues, our professional support team is available 24/7 to assist you. Royelclub is committed to providing safe, fast, and transparent services for every user.';
				$list[1]['addtime'] = '2025-07-01 12:01:22';

				$data['list'] = $list;

				$res['data'] = $data;
				$res['code'] = 0;
				$res['msg'] = 'Succeed';
				$res['msgCode'] = 0;

				http_response_code(200);
				echo json_encode($res, JSON_UNESCAPED_UNICODE);

			} else {
				$res['code'] = 5;
				$res['msg'] = 'Wrong signature';
				$res['msgCode'] = 3;
				http_response_code(200);
				echo json_encode($res);
			}

		} else {
			$res['code'] = 7;
			$res['msg'] = 'Param is Invalid';
			$res['msgCode'] = 6;
			http_response_code(200);
			echo json_encode($res);
		}

	} else {
		http_response_code(405);
		echo json_encode($res);
	}
?>
