<?php
date_default_timezone_set('Asia/Kolkata');

function waitForSecond($interval)
{
	while (true) {
		$currentSecond = (int)date('s');
		$currentMinute = (int)date('i');
		// Calculate which second in the minute we should be at (0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55 for 5 min)
		// For 5 min intervals, periods start at :00, :05, :10, etc. of each minute
		$targetSecond = ($currentMinute % $interval) * 60;
		if ($currentSecond >= $targetSecond && $currentSecond < $targetSecond + 1) {
			break;
		}
		usleep(100000);
	}
}

// Wait for the next 5-minute interval (00, 05, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55 seconds)
$currentSecond = (int)date('s');
$currentMinute = (int)date('i');
$targetSecond = ($currentMinute % 5) * 60;
if ($currentSecond != $targetSecond) {
	waitForSecond(5);
}

include("serive/samparka.php");

try {
	include("nayakaphalitansa_mulaka_unohs_funf.php");

	$prathama = date('Ymd') . "10003" . sprintf("%04d", 1);
	$sesa = $lastperiodid = date('Ymd') . "10003" . sprintf("%04d", 288);

	$ajitarika = date('Ymd');
	// Calculate sequence number (1-288 for 5-minute intervals in a day)
	$timeInSeconds = time() % 86400;
	$sequenceNumber = intval($timeInSeconds / 300) + 1; // 1-based (1 to 288) - 300 seconds = 5 minutes
	if ($sequenceNumber > 288) {
		$sequenceNumber = 1; // Reset to 1 if exceeds max
	}
	$uniqueSequence = str_pad($sequenceNumber, 4, '0', STR_PAD_LEFT);

	$bartamankalakrama = $ajitarika . "10003" . $uniqueSequence;

	$tarika = date('Y-m-d H:i:s');

	$dekhakalakrama = mysqli_query($conn, "select atadaaidi from `gelluonduhogu_funf` order by kramasankhye desc limit 1");
	$kaladhadi = mysqli_num_rows($dekhakalakrama);
	$kalakramadhadi = mysqli_fetch_array($dekhakalakrama);

	$lastPeriod = $kalakramadhadi ? $kalakramadhadi['atadaaidi'] : null;
	$lastDate = $lastPeriod ? substr($lastPeriod, 0, 8) : null;

	// Check if it's a new day
	if ($lastDate != $ajitarika) {
		// New day, truncate and insert first period
		$katiba = mysqli_query($conn, "TRUNCATE TABLE `gelluonduhogu_funf`");
		$tathya = mysqli_query($conn, "INSERT INTO `gelluonduhogu_funf` (`atadaaidi`,`dinankavannuracisi`) VALUES ('" . $bartamankalakrama . "','" . $tarika . "')");
	} else {
		// Same day, check if period already exists
		$checkPeriod = mysqli_query($conn, "SELECT atadaaidi FROM `gelluonduhogu_funf` WHERE atadaaidi = '" . $bartamankalakrama . "' LIMIT 1");
		$periodExists = mysqli_num_rows($checkPeriod);

		if ($periodExists == 0) {
			// Period doesn't exist, insert it
			$tathya = mysqli_query($conn, "INSERT INTO `gelluonduhogu_funf` (`atadaaidi`,`dinankavannuracisi`) VALUES ('" . $bartamankalakrama . "','" . $tarika . "')");
		} else {
			// Period exists, update timestamp
			$tathya = mysqli_query($conn, "UPDATE `gelluonduhogu_funf` SET `dinankavannuracisi` = '" . $tarika . "' WHERE `atadaaidi` = '" . $bartamankalakrama . "'");
		}
	}

	$safa_shonu = mysqli_query($conn, "UPDATE hastacalita_phalitansa_funf SET sthiti='0'");

} finally {
	if (isset($conn) && $conn instanceof mysqli) {
		mysqli_close($conn);
	}
	$conn = null;
}
?>