<?php
session_start();
if ($_SESSION['unohs'] == null) {
    header("location:index.php?msg=unauthorized");
    exit();
}

include("conn.php");

// Decrypt ID and fetch withdrawal info
$Result = null;
if ($id = encryptor('decrypt', $_GET['id'])) {
      $Query = mysqli_query($conn, "
        SELECT 
            shonu_subjects.mobile,
            shonu_subjects.email,
            shonu_subjects.owncode,
            bankcard.id,
            bankcard.userid,
            bankcard.type,
            bankcard.account,
            bankcard.name,
            hintegedukolli.shonu,
            hintegedukolli.motta,
            hintegedukolli.khateshonu,
            hintegedukolli.sthiti,
            hintegedukolli.dinankavannuracisi
        FROM hintegedukolli
        INNER JOIN shonu_subjects 
            ON shonu_subjects.id = hintegedukolli.balakedara
        INNER JOIN bankcard 
            ON bankcard.id = hintegedukolli.khateshonu
        WHERE hintegedukolli.shonu = '".$id."'
    ");
    $Result = mysqli_fetch_array($Query, MYSQLI_ASSOC);
    
    print_r($Result);
}

// Withdraw methods JSON
$json = '[
    {
        "bankID": 175,
        "bankLogo": "https://ossimg.dkwinpicture.com/dkwin",
        "bankName": "BKASH",
        "reserved": "4"
    },
    {
        "bankID": 176,
        "bankLogo": "https://ossimg.dkwinpicture.com/dkwin",
        "bankName": "ROCKET",
        "reserved": "4"
    },
    {
        "bankID": 177,
        "bankLogo": "https://ossimg.dkwinpicture.com/dkwin",
        "bankName": "UPAY",
        "reserved": "4"
    },
    {
        "bankID": 178,
        "bankLogo": "https://ossimg.dkwinpicture.com/dkwin",
        "bankName": "NAGAD",
        "reserved": "4"
    },
    {
        "bankID": 237,
        "bankLogo": "https://ossimg.dkwinpicture.com/dkwin",
        "bankName": "Surecash",
        "reserved": "4"
    }
]';

$withdrawMethods = json_decode($json, true);

// defaults
$methodName = "Unknown";
$methodImg  = "images/default.png";

// Find method details
if ($Result) {
    foreach ($withdrawMethods as $method) {
        // Match by bank name (if DB stores name)
        if (isset($Result['type']) && strtoupper($method['bankName']) == strtoupper($Result['type'])) {
            $methodName = $method['bankName'];
            $methodImg  = $method['bankLogo'];
            break;
        }
        echo $Result['type'];
        // Match by numeric ID (if DB stores ID)
        if ($method['bankID'] == $Result['type']) {
            $methodName = $method['bankName'];
            $methodImg  = $method['bankLogo'];
            break;
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <title>Withdraw Details</title>

  <link rel="stylesheet" href="vendors/mdi/css/materialdesignicons.min.css">
  <link rel="stylesheet" href="vendors/feather/feather.css">
  <link rel="stylesheet" href="vendors/base/vendor.bundle.base.css">
  <link rel="stylesheet" href="vendors/flag-icon-css/css/flag-icon.min.css"/>
  <link rel="stylesheet" href="vendors/font-awesome/css/font-awesome.min.css">
  <link rel="stylesheet" href="vendors/jquery-bar-rating/fontawesome-stars-o.css">
  <link rel="stylesheet" href="vendors/jquery-bar-rating/fontawesome-stars.css">
  <link rel="stylesheet" href="css/style.css">
  <link rel="stylesheet" href="plugins/datatables/dataTables.bootstrap.css">
  <link rel="stylesheet" href="https://cdn.datatables.net/1.12.1/css/jquery.dataTables.min.css">
  <link rel="stylesheet" href="https://cdn.datatables.net/fixedheader/3.2.3/css/fixedHeader.dataTables.min.css">
  <link rel="shortcut icon" href="images/favicon.png" />
</head>

<body>
  <div class="container-scroller">
    <!-- NAVBAR -->
    <nav class="navbar col-lg-12 col-12 p-0 fixed-top d-flex flex-row">
      <div class="text-center navbar-brand-wrapper d-flex align-items-center justify-content-center">
        <a class="navbar-brand brand-logo" href="dashboard.php"><img src="images/logo.png" alt="logo"/></a>
        <a class="navbar-brand brand-logo-mini" href="dashboard.php"><img src="images/logo-mini.png" alt="logo"/></a>
      </div>
      <div class="navbar-menu-wrapper d-flex align-items-center justify-content-end">
        <button class="navbar-toggler align-self-center" type="button" data-toggle="minimize">
          <span class="icon-menu"></span>
        </button>
        <ul class="navbar-nav navbar-nav-right">
          <li class="nav-item dropdown d-flex mr-4">
            <a class="nav-link count-indicator dropdown-toggle d-flex align-items-center justify-content-center" id="notificationDropdown" href="#" data-toggle="dropdown">
              <i class="icon-cog"></i>
            </a>
            <div class="dropdown-menu dropdown-menu-right navbar-dropdown preview-list" aria-labelledby="notificationDropdown">
              <p class="mb-0 font-weight-normal float-left dropdown-header">Settings</p>
              <a class="dropdown-item preview-item" href="logout.php">
                <i class="icon-inbox"></i> Logout
              </a>
            </div>
          </li>
        </ul>
      </div>
    </nav>

    <div class="container-fluid page-body-wrapper">
      <!-- SIDEBAR -->
      <nav class="sidebar sidebar-offcanvas" id="sidebar">
        <div class="user-profile">
          <div class="user-image">
            <img src="images/faces/face28.png" alt="">
          </div>
          <div class="user-name">Source Code</div>
          <div class="user-designation">Admin</div>
        </div>
        <?php include 'compass.php';?>
      </nav>

      <!-- MAIN CONTENT -->
      <div class="main-panel">
        <div class="content-wrapper">
          <div class="row">
            <div class="col-sm-12 mb-4 mb-xl-0">
              <h4 class="font-weight-bold text-dark">Withdraw Accept / Reject</h4>
            </div>
          </div>

          <div class="row">
            <div class="col-sm-12">
              <h3 class="box-title text-center text-danger">Bank Withdrawal</h3>

              <?php if ($Result): ?>
                <table class="table">
                  <tbody>
                    <tr>
                      <td style="color: blue; font-size:25px;">Mobile:</td>
                      <td style="color: blue; font-size:25px;"><?php echo htmlspecialchars($Result['mobile']); ?></td>
                    </tr>
                    <tr>
                      <td style="color: blue; font-size:25px;">Date:</td>
                      <td style="color: blue; font-size:25px;"><?php echo date('d-m-Y', strtotime($Result['dinankavannuracisi'])); ?></td>
                    </tr>
                    <tr>
                      <td style="color: blue; font-size:25px;">Amount:</td>
                      <td style="color: blue; font-size:25px;"><?php echo number_format($Result['motta'], 2); ?></td>
                    </tr>
                    <tr>
                      <td style="color: blue; font-size:25px;">Account Number:</td>
                      <td style="color: blue; font-size:25px;"><?php echo htmlspecialchars($Result['account']); ?></td>
                    </tr>
                    <tr>
                      <td style="color: blue; font-size:25px;">Account Name:</td>
                      <td style="color: blue; font-size:25px;"><?php echo htmlspecialchars($Result['name']); ?></td>
                    </tr>
                    <tr>
                      <td style="color: blue; font-size:25px;">Type:</td>
                      <td style="color: blue; font-size:25px;">
                        <img src="<?php echo $methodImg; ?>" alt="<?php echo $methodName; ?>" width="40">
                        <?php echo $methodName; ?>
                      </td>
                    </tr>
                    <tr>
                      <td style="color: blue; font-size:25px;">User ID:</td>
                      <td style="color: blue; font-size:25px;"><?php echo htmlspecialchars($Result['userid']); ?></td>
                    </tr>
                  </tbody>
                </table>
              <?php else: ?>
                <p class="text-danger">❌ No withdraw record found.</p>
              <?php endif; ?>
            </div>

            <?php if ($Result): ?>
            <div class="col-sm-12">
              <div class="d-flex">
                <div class="col-sm-6">
                  <a href="manage_withdrawAction.php?id=<?php echo $Result['shonu']; ?>&type=accept&remark=<?php echo urlencode('Approved'); ?>"
                    class="btn btn-success btn-block">
                    <strong><i class="fa fa-check"></i> Approve</strong>
                  </a>
                </div>
                <div class="col-sm-6">
                  <a href="manage_withdrawAction.php?id=<?php echo $Result['shonu']; ?>&type=reject&remark=<?php echo urlencode('Rejected due to mismatch'); ?>"
                    class="btn btn-danger btn-block">
                    <strong><i class="fa fa-times"></i> Reject</strong>
                  </a>
                </div>
              </div>
            </div>
            <?php endif; ?>
          </div>
        </div>

        <footer class="footer">
          <div class="d-sm-flex justify-content-center justify-content-sm-between">
            <span class="text-muted d-block text-center text-sm-left d-sm-inline-block">
              Copyright © Source Code 2025
            </span>
          </div>
        </footer>
      </div>
    </div>
  </div>
</body>
</html>
